#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os, sys, site 
import re, urllib
import datetime, time
import shutil
import codecs
import glob 

from bs4 import BeautifulSoup

import sqlite3dbm

from generator import * 
from models import *

import web

from mako.template import Template
from mako.lookup import TemplateLookup
TLOOKUP = TemplateLookup(   directories=[PANEO_SITE_DATA_DIR+'/_paneo_data/templates/include/'],
                            input_encoding='utf-8',
                            output_encoding='utf-8',
                            encoding_errors='replace', 
                            default_filters=["none_to_blank", "unicode" ],
                            #cache_impl='beaker',
                            #cache_args={
                            #},
                            imports=[ 
                                    'from models import VIEWED',
                                    '''from generator import (
                                                PANEO_ROOT,
                                                PANEO_SITE_DIR,
                                                PANEO_SITE_DATA_DIR,
                                                TEMPLATE_DIR,
                                                TEMPLATE_INC_DIR,
                                                ARTICLES,
                                                ARTICLES_TYPE,
                                                none_to_blank,
                                    )'''
])

from paneo_html import GenerateHtmlTemplate,GenerateCssTemplate,PaneoImage

dt = datetime.datetime.today().strftime("%Y%m%d%H")

class PaneoPage(object):

    def __init__(   self,
                    IDX         = None,
                    TYPE        = 'MENU', # MENU or HTML
                    PARENT      = None,
                    TEMPLATE    = "skelton",
                    TEMPLATE_SYSTEM_USE = False,
                    VIEWED      = None,
                    TITLE       = u"",
                    LINK        = u"",
                    CONTEXT     = {},
                    IMG         = None, ):
   
        self.IDX = IDX
        self.TYPE = TYPE
        self.PARENT = PARENT 
        self.TEMPLATE = TEMPLATE
        self.TEMPLATE_SYSTEM_USE = TEMPLATE_SYSTEM_USE 
        self.VIEWED = VIEWED
        self.TITLE = TITLE
        self.LINK = LINK
        self.CONTEXT = CONTEXT
        self.IMG = IMG

    def __PageTemplateFile(self,id,post=None):
        self.Refresh()
        if post is None:
            if self.TEMPLATE_SYSTEM_USE:
                tempdir = TEMPLATE_DIR + 'page_templateset/' + PAGE_TEMPLATE_SET + '/' 
                filename = tempdir + self.TEMPLATE + '.html'
            else:
                if id == 'index':
                    filename = PANEO_SITE_DATA_DIR + id + '.html'
                else:
                    filename = PANEO_SITE_DATA_DIR + 'pages/' + id + '.html'
            #DEFAULT TEMPLATE FILE
            if not os.path.exists( filename ):
                filename = TEMPLATE_DIR + 'page_templateset/' + PAGE_TEMPLATE_SET + '/skelton.html'
        else:
            tempdir = TEMPLATE_DIR + 'article_templateset/' + post.article.template_set + '/' 
            #MAKE FOLDER
            if not os.path.exists( tempdir ):
                os.mkdir( tempdir )
            if not os.path.exists( tempdir + 'skelton.html'):
                shutil.copyfile(TEMPLATE_DIR + 'article_templateset/default/skelton.html',tempdir + 'skelton.html')
            filename = tempdir + post.template + '.html'
            if not os.path.exists( filename ):
                filename = TEMPLATE_DIR + 'article_templateset/default/skelton.html'
        return filename


    def __PageBeautifulSoup(self,id,post=None):
        file = codecs.open( self.__PageTemplateFile(id,post),"r","utf8")
        html = file.read()
        file.close()
        #return BeautifulSoup(html,"html5lib",fromEncoding="utf8")
        #try:
        #    import lxml
        #    return BeautifulSoup(html,"lxml",fromEncoding="utf8")
        #except:
        return BeautifulSoup(html,"html.parser",fromEncoding="utf8")

    def __PageBeautifulSoupMakoCompile(self,id,post=None):

        file = codecs.open( self.__PageTemplateFile(id,post),"r","utf8")
        html = file.read()
        file.close()

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        #新着記事共通
        AT = ArticlesType.select(ArticlesType.q.id == '1').getOne(default=None)
        
        template = Template(    
                                html,
                                lookup=TLOOKUP,
        )

        ua = web.ctx.env['HTTP_USER_AGENT'].lower()
        PANEO = False
        if ua.find('paneo') != -1 :
            PANEO = True

        html = template.render( 
                                web = web,
                                paneoimg = PaneoImage,
                                scfg=scfg,
                                pages = pages,
                                ua_option = None,
                                AT = AT,
                                id = id,
                                post = post,
                                bookmark = {},
                                PANEO = PANEO,
        )

        return BeautifulSoup(html,"html.parser",fromEncoding="utf8")

    def GetTemplateToBeautifulSoupMakeCompile(self,html,page=None,post=None):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        #新着記事共通
        AT = ArticlesType.select(ArticlesType.q.id == '1').getOne(default=None)
        
        template = Template(    
                                html,
                                lookup=TLOOKUP,
        )

        ua = web.ctx.env['HTTP_USER_AGENT'].lower()
        PANEO = False
        if ua.find('paneo') != -1 :
            PANEO = True

        html = template.render( 
                                web = web,
                                paneoimg = PaneoImage,
                                scfg=scfg,
                                pages = pages,
                                ua_option = None,
                                AT = AT,
                                id = id,
                                post = None,
                                bookmark = {},
                                PANEO =PANEO,
        )
        return BeautifulSoup(html,"html.parser",fromEncoding="utf8")


    def Refresh(self):
        self.IDX = self.IDX
        self.TYPE = self.TYPE
        self.PARENT = self.PARENT 
        self.TEMPLATE = self.TEMPLATE
        self.TITLE = self.TITLE
        self.LINK = self.LINK
        self.IMG = self.IMG
        if self.has_key('TEMPLATE_SYSTEM_USE') :
            self.TEMPLATE_SYSTEM_USE = self.TEMPLATE_SYSTEM_USE 
        else:
            self.TEMPLATE_SYSTEM_USE = False
        if self.has_key('VIEWED'):
            self.VIEWED = self.VIEWED
        else:
            self.VIEWED = 1  


    def PaneoMakeHtmlTemplate(self,id,page=None,post=None):
        #bs = self.__PageBeautifulSoup(id,post)
        bs = self.__PageBeautifulSoupMakoCompile(id,post)
        temp_html = GenerateHtmlTemplate(id,bs,page,post)
        return temp_html


    def PaneoMakeCssTemplate(self,id,page=None,post=None):
        bs = self.__PageBeautifulSoup(id,post)
        temp_css = GenerateCssTemplate(id,bs,page,post)
        return temp_css


    def GetTemplateFolderName(self,post=None):
        if post is None:
            temp = '_paneo_data/templates/page_templateset/' + PAGE_TEMPLATE_SET + '/' 
        else:
            temp = '_paneo_data/templates/article_templateset/' + post.article.template_set + '/' 
        return temp 


    def GetPageTemplateFile(self,id,post=None):
        file = codecs.open( self.__PageTemplateFile(id,post),"r","utf8")
        html = file.read()
        file.close()
        return html 


    def PostPageTemplateFile(self,id,html,post=None):
        if post is None:

            if self.TEMPLATE_SYSTEM_USE and ( id != 'index' ):
                tempdir = TEMPLATE_DIR + 'page_templateset/' + PAGE_TEMPLATE_SET + '/' 
                filename = tempdir + self.TEMPLATE + '.html'
            else:
                if id == 'index':
                    filename = PANEO_SITE_DATA_DIR + id + '.html'
                else:
                    filename = PANEO_SITE_DATA_DIR + 'pages/' + id + '.html'
            #BACKUP 
            if os.path.exists(filename):
                if self.TEMPLATE_SYSTEM_USE:
                    shutil.copyfile(filename,TEMPLATE_DIR+'_backup/page_'+PAGE_TEMPLATE_SET+'_'+self.TEMPLATE+'_'+id+'.html.'+dt+'.bak')
                else:
                    shutil.copyfile(filename,TEMPLATE_DIR+'_backup/'+id+'.html.'+dt+'.bak')

            file = codecs.open(filename,"w","utf8")
            file.write(html)
            file.close()
        else:
            filename = PANEO_SITE_DATA_DIR + self.GetTemplateFolderName(post) + post.template + '.html'
            if os.path.exists(filename):
                shutil.copyfile(filename,TEMPLATE_DIR+'_backup/article_'+post.article.template_set +'_'+post.template+'.html.'+dt+'.bak')
            file = codecs.open(filename,"w","utf8")
            file.write(html)
            file.close()
        return html


    def PostPageChangeTemplateFile(self,id,name,post=None):
        if not post :
            if id != 'index':
                filename = PANEO_SITE_DATA_DIR + id + '.html'
                #BACKUP 
                if os.path.exists(filename):
                    shutil.copyfile(filename,TEMPLATE_DIR+'_backup/'+id+'.html.'+dt+'.bak')
                tempfile = TEMPLATE_DIR + 'page_templateset/' + PAGE_TEMPLATE_SET + '/' + name + '.html' 
                shutil.copyfile(tempfile,filename)

    def GetPageTemplateNames(self,id,post=None):
        templates = {}
        if post is None:
            tempdir = TEMPLATE_DIR + 'page_templateset/' + PAGE_TEMPLATE_SET + '/' 
        else:
            tempdir = TEMPLATE_DIR + 'article_templateset/' + post.article.template_set + '/' 

        tmps = glob.glob( tempdir + '*.html')
        n = 0
        for f in tmps:
            fname = os.path.split(f)[1]
            file = codecs.open(f,"r","utf8")
            tmp_bs = BeautifulSoup(file.read(),"html5lib",fromEncoding="utf8")
            file.close()
            tmp_dic = {'title':tmp_bs.title.string}
            name, ext = os.path.splitext(fname)
            templates[name] = [n,tmp_dic]
            n = n + 1
        return templates 


    def GetPageImageFields(self,prefix,id):
        page_img = {} 
        for ii in range(1,4):
            file = '%s_%s_img%s_file' % ( prefix, id , ii )
            if IMG_CONV :
                src = "/img/%s_%s_img%s" % ( prefix , id, ii )
            else:
                src = "/%s/img/%s_%s_img%s" % ( PANEO_SITE_DIR ,prefix, id , ii )
            page_img[file] = [ os.path.exists(PANEO_SITE_DATA_DIR + "img/%s_%s_img%s" % (prefix,id,ii)) , src ]
        return page_img        


    def PostPageImageFields(self,prefix,i,id):
        img_alt = {}
        for ii in range(1,4):
            if i.has_key('%s_%s_img%s_file_del' % (prefix,id,ii)):
                if os.path.exists(PANEO_SITE_DATA_DIR + "img/%s_%s_img%s" % (prefix,id,ii)):
                    os.remove(PANEO_SITE_DATA_DIR + "img/%s_%s_img%s" % (prefix,id,ii))
            f = '%s_%s_img%s_file' % (prefix,id,ii)
            if i.has_key(f):
                if i[f] != "":
                    fout = open(PANEO_SITE_DATA_DIR + "img/%s_%s_img%s" % (prefix,id,ii),'wb')
                    fout.write(i[f])
                    fout.close()
                    #CACHE DELETE
                    cache_imgs = glob.glob(PANEO_SITE_DATA_DIR + '_tmp/cache/img/%s_%s_img%s*' %  (prefix,id,ii) ) 
                    for cache_img in cache_imgs:
                        os.remove(cache_img)

            alt = '%s_%s_img%s_alt' % (prefix,id,ii)
            img_alt[alt] = i[alt]
        self.IMG = img_alt        

    def GetPaneoTextFields(self,prefix,id,fields,post=None):

        #bs = self.__PageBeautifulSoup(id,post)
        bs = self.__PageBeautifulSoupMakoCompile(id,post)
        paneo_fields = {}

        #META 変数 
        n = 1
        for m in bs.find_all(attrs={"name":"paneo-field-text"}):
            ct = m.get('content')
            if ct != "" :
                ct = ct.split(",")
                for c in ct:
                    cc = c.split(":")
                    paneo_name = cc[0]
                    if len(cc) > 1 :
                        title = cc[1]
                    else:
                        title = u"ページ変数 [%s]" % cc
                    k = 'txt_%s_%s_%s'%(prefix,id,paneo_name)
                    fld = fields.get(k)
                    if fld :
                        string = fld.get('string').strip()
                    else:
                        string = ""

                    f = PaneoField()
                    f.idx = n
                    f.tag = 'meta'
                    f.type = 'text'
                    f.name = paneo_name
                    f.title = title
                    f.string = string.strip()
                    f.ext = {}
                    paneo_fields[k] = f 
                    n = n + 1

        #HEADER TAG
        n = 51
        for tag in bs.find_all(re.compile("h['1','2','3','4','5']")):
            paneo_type = tag.get('data-paneo-type')
            paneo_name = tag.get('data-paneo-name')
            title = tag.get('title')
            if paneo_name is not None and paneo_type is not None:
                if paneo_type == "text":
                    k = 'txt_%s_%s_%s'%(prefix,id,paneo_name)
                    fld = fields.get(k)
                    if fld :
                        string = fld.get('string').strip()
                    else:
                        string = ""
                    if title is None:
                        title = u"%sタグ [%s]" % ( tag.name, n - 50 )

                    f = PaneoField()
                    f.idx = n
                    f.tag = tag.name
                    f.type = paneo_type 
                    f.name = paneo_name
                    f.title = title
                    f.string = string.strip()
                    f.ext = {}

                    paneo_fields[k] = f 
                    n = n + 1
       
        #PARAGRA
        n = 101
        for tag in bs.find_all('p'):
            paneo_type = tag.get('data-paneo-type')
            paneo_name = tag.get('data-paneo-name')
            title = tag.get('title')
            if paneo_name is not None and paneo_type is not None:
                if paneo_type == "text" or paneo_type == 'textarea':
                    k = 'txt_%s_%s_%s'%(prefix,id,paneo_name)
                    fld = fields.get(k)
                    if fld :
                        string = fld.get('string').strip()
                    else:
                        string = "".join([unicode(t) for t in tag.contents])
                    if title is None:
                        title = u"段落テキスト [%s]" % n - 100 

                    f = PaneoField()
                    f.idx = n
                    f.tag = tag.name
                    f.type = paneo_type 
                    f.name = paneo_name
                    f.title = title
                    f.string = string.strip()
                    f.ext = {}

                    paneo_fields[k] = f 
                    n = n + 1

        #DIV SECTION
        n = 201
        for tag in bs.find_all(['div','span','article','section','dd','li','address']):
            paneo_type = tag.get('data-paneo-type')
            paneo_name = tag.get('data-paneo-name')
            title = tag.get('title')
            if paneo_name is not None and paneo_type is not None:
                if paneo_type == "text" or paneo_type == 'textarea':
                    k = 'txt_%s_%s_%s'%(prefix,id,paneo_name)
                    fld = fields.get(k)
                    if fld :
                        string = fld.get('string')
                    else:
                        string = "".join([unicode(t) for t in tag.contents])
                    if title is None:
                        title = u"コンテンツ [%s]" % ( n - 200 ) 

                    f = PaneoField()
                    f.idx = n
                    f.tag = tag.name
                    f.type = paneo_type 
                    f.name = paneo_name
                    f.title = title
                    f.string = string.strip()
                    f.ext = {}

                    paneo_fields[k] = f 
                    n = n + 1

        n = 501
        anchor = bs.find_all('a')
        for tag in bs.find_all('a'):
            paneo_type = tag.get('data-paneo-type')
            paneo_name = tag.get('data-paneo-name')
            title = tag.get('title')
            if paneo_name is not None and paneo_type is not None:
                if paneo_type == "text-link" :
                    k = 'a_%s_%s_%s'%(prefix,id,paneo_name)
                    fld = fields.get(k)
                    if fld :
                        string = fld.get('string')
                        href = fld.get('ext',{}).get('href','')
                    else:
                        string = "".join([unicode(t) for t in tag.contents])
                        href = tag.get('href','')

                    if title is None:
                        title = u"テキストリンク [%s]" % ( n - 500 )

                    f = PaneoField()
                    f.idx = n
                    f.tag = tag.name
                    f.type = paneo_type 
                    f.name = paneo_name
                    f.title = title
                    f.string = string.strip()
                    f.ext = {
                                'href': href.strip()         
                    }
                    paneo_fields[k] = f 
                    n = n + 1

        return paneo_fields



    def PostPaneoTextFields(self,prefix,id,fields,post=None):

        i = web.input()
        bs = self.__PageBeautifulSoupMakoCompile(id,post)

        for k,v in i.items():
            if len(k.split('_')) < 3 :
                continue
            k_sp = k.split('_')
            k_name = k.replace(k_sp[0] + '_' + k_sp[1] + '_' + k_sp[2] + '_','')
            tag = bs.find_all(attrs={"data-paneo-name":k_name})
            if len(tag) > 0 :
                tag = tag[0]
                tag_name = tag.name
                #tag_contents = "".join([unicode(t) for t in tag.contents])
                tag_contents = ""
            else:
                tag = {}
                tag_name = "" 
                tag_contents = ""

            paneo_type = tag.get('data-paneo-type')
            paneo_name = tag.get('data-paneo-name')
            title = tag.get('title')

            #META CHECK
            if not paneo_type :
                for m in bs.find_all(attrs={"name":"paneo-field-text"}):
                    ct = m.get('content')
                    if ct != "" :
                        ct = ct.split(",")
                        for c in ct:
                            cc = c.split(":")
                            _paneo_name = cc[0]
                            if _paneo_name == k_name:
                                paneo_type = "text"
                                paneo_name = _paneo_name

                                if len(cc) > 1 :
                                    title = cc[1]
                                else:
                                    title = u"ページ変数 [%s]" % cc
                                tag_name = "meta"
                                tag_contents = ""

            if paneo_name is not None and paneo_type is not None:
                string = v
                href = ""
                if k[0:2] == 'a_' and k[-4] != '_href':
                    href = i.get(k+'_href','')
                else:
                    if v == "":
                        string = tag_contents

                f = PaneoField()
                f.idx       = k 
                f.tag       = tag_name
                f.type      = paneo_type 
                f.name      = paneo_name
                f.title     = title
                f.string    = string.strip()
                f.ext = {
                            'href': href.strip()         
                }
                fields[k] = f 

        return fields


    def GetPaneoImageFields(self,prefix,id,fields,post=None):

        bs = self.__PageBeautifulSoupMakoCompile(id,post)

        paneo_fields = {}

        #META 変数 
        n = 1
        for m in bs.find_all(attrs={"name":"paneo-field-img"}):
            ct = m.get('content')
            if ct != "" :
                ct = ct.split(",")
                for c in ct:
                    cc = c.split(":")
                    paneo_name = cc[0]
                    paneo_type = "img" 
                    if len(cc) > 1 :
                        title = cc[1]
                    else:
                        title = u"ページ画像 [%s]" % cc
                    k = 'img_%s_%s_%s'%(prefix,id,paneo_name)
                    fld = fields.get(k)
                    if fld :
                        ext = fld.get('ext',{})
                        alt = ext.get('alt') 
                        img_src = ext.get('img_src') 
                        src = ext.get('src') 
                        src_on = ext.get('src_on')
                        caption = ext.get('caption')
                    else:
                        alt = "" 
                        img_src = "" 
                        src = "" 
                        src_on = False 
                        caption = ""
                    
                    #画像があるかどうかチェック
                    if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                        if src_on is False:
                            img_src = "/" + PANEO_SITE_DIR + "/img/" + k

                    if title is None:
                        title = u"画像 [%s]" % n

                    f = PaneoField()
                    f.idx = n
                    f.tag = "img" 
                    f.type = paneo_type 
                    f.name = paneo_name
                    f.title = title.strip()
                    f.string = None 
                    f.ext = {
                            'href'      :   None,
                            'alt'       :   alt,
                            'img_src'   :   img_src,
                            'src'       :   src,
                            'src_on'    :   src_on,
                            'caption'   :   caption,
                    }
                    paneo_fields[k] = f 
                    n = n + 1


        n = 50 
        for img in bs.find_all('img'):

            paneo_type = img.get('data-paneo-type')
            paneo_name = img.get('data-paneo-name')
            title = img.get('title')

            if paneo_type is not None and paneo_name is not None:
                if paneo_type == "img" or paneo_type == "image":
                    k = ('img_%s_%s_%s'%(prefix,id,paneo_name))
                    fld = fields.get(k)
                    if fld :
                        ext = fld.get('ext',{})
                        alt = ext.get('alt') 
                        img_src = ext.get('img_src') 
                        src = ext.get('src') 
                        src_on = ext.get('src_on')
                        caption = ext.get('caption')
                    else:
                        alt = img.get('alt') 
                        img_src = img.get('img_src') 
                        src = img.get('src') 
                        src_on = False 
                        caption = ""
                    
                    #画像があるかどうかチェック
                    if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                        if src_on is False:
                            img_src = "/" + PANEO_SITE_DIR + "/img/" + k

                    if title is None:
                        title = u"画像 [%s]" % n

                    f = PaneoField()
                    f.idx = n
                    f.tag = img.name 
                    f.type = paneo_type 
                    f.name = paneo_name
                    f.title = title.strip()
                    f.string = None 
                    f.ext = {
                            'href'      :   None,
                            'alt'       :   alt,
                            'img_src'   :   img_src,
                            'src'       :   src,
                            'src_on'    :   src_on,
                            'caption'   :   caption,
                    }

                    paneo_fields[k] = f 
                    n = n + 1

        n = 101 
        for tag in bs.find_all('a'):
            paneo_type = tag.get('data-paneo-type')
            paneo_name = tag.get('data-paneo-name')
            title = tag.get('title')
            if paneo_type is not None and paneo_name is not None:
                if paneo_type == "link-image" or paneo_type == "image-link":
                    img = tag.find('img')
                    k = ('img_%s_%s_%s'%(prefix,id,paneo_name))
                    fld = fields.get(k)
                    if fld :
                        ext = fld.get('ext',{})
                        alt = ext.get('alt') 
                        href = ext.get('href')
                        img_src = ext.get('src') 
                        src = ext.get('src') 
                        src_on = ext.get('src_on')
                    else:
                        href = tag.get('href')
                        alt = img.get('alt') 
                        img_src = img.get('src') 
                        src = img.get('src') 
                        src_on = False 

                    f = PaneoField()

                    #画像があるかどうかチェック
                    if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                        if src_on is False:
                            img_src = "/" + PANEO_SITE_DIR + "/img/" + k + "?" + dt

                    if title is None:
                        title = u"リンク画像 [%s]" % ( n - 100)

                    f = PaneoField()
                    f.idx = n
                    f.tag = img.name 
                    f.type = paneo_type 
                    f.name = paneo_name
                    f.title = title.strip()
                    f.string = None 
                    f.ext = {
                            'href'      :   None,
                            'img_src'   :   img_src,
                            'src'       :   src,
                            'src_on'    :   src_on,
                            'alt'       :   alt,
                    }

                    paneo_fields[k] = f 
                    n = n + 1

        return paneo_fields 



    def PostPaneoImageFields(self,prefix,id,fields,post=None):

        i = web.input()
        bs = self.__PageBeautifulSoupMakoCompile(id,post)

        for m in bs.find_all(attrs={"name":"paneo-field-img"}):
            ct = m.get('content')
            if ct != "" :
                ct = ct.split(",")
                for c in ct:
                    cc = c.split(":")
                    paneo_name = cc[0]
                    paneo_type = "img" 
                    if len(cc) > 1 :
                        title = cc[1]
                    else:
                        title = u"ページ画像 [%s]" % cc
                    k = 'img_%s_%s_%s'%(prefix,id,paneo_name)
                    #DELETE
                    if i.has_key(k+'_file_del'):
                        if os.path.exists(PANEO_SITE_DATA_DIR + "img/" + k):
                            os.remove(PANEO_SITE_DATA_DIR + "img/" + k)
                    #UPLOAD
                    if i.has_key(k+'_file'):
                        if i[k+'_file'] != "":
                            fout = open(PANEO_SITE_DATA_DIR + "img/" + k,'wb') 
                            fout.write(i[k+'_file']) 
                            fout.close() 
                            #CACHE DELETE
                            cache_imgs = glob.glob(PANEO_SITE_DATA_DIR + '_tmp/cache/img/%s_*' % k ) 
                            for cache_img in cache_imgs:
                                os.remove(cache_img)

                    #data
                    if i[k+'_alt'] != "":
                        alt =  i[k+'_alt']
                    else:
                        alt = "" 

                    if i[k + '_src'] != "":
                        src =  i[k+'_src']
                    else:
                        src = "" 

                    if i[k + '_caption'] != "":
                        caption = i[k+'_caption']
                    else:
                        caption = ""

                    src_on = i.has_key(k+'_src_on')
                    if src_on is False:
                        img_src = "/" + PANEO_SITE_DIR + "/img/" + k
                    else:
                        img_src = src

                    f = PaneoField()
                    f.idx = k 
                    f.tag = "img"
                    f.type = paneo_type 
                    f.name = paneo_name
                    f.title = title.strip()
                    f.string = None 
                    f.ext = {
                            'href'      :   None,
                            'alt'       :   alt,
                            'img_src'   :   img_src,
                            'src'       :   src,
                            'src_on'    :   src_on,
                            'caption'   :   caption,
                    }
                    fields[k] = f

        for img in bs.find_all('img'):
            paneo_type = img.get('data-paneo-type')
            paneo_name = img.get('data-paneo-name')
            title = img.get('title')
            if paneo_type is not None and paneo_name is not None:
                k = "img_%s_%s_%s" % ( prefix ,id , paneo_name )
                #DELETE
                if i.has_key(k+'_file_del'):
                    if os.path.exists(PANEO_SITE_DATA_DIR + "img/" + k):
                        os.remove(PANEO_SITE_DATA_DIR + "img/" + k)
                #UPLOAD
                if i.has_key(k+'_file'):
                    if i[k+'_file'] != "":
                        fout = open(PANEO_SITE_DATA_DIR + "img/" + k,'wb') 
                        fout.write(i[k+'_file']) 
                        fout.close() 
                        #CACHE DELETE
                        cache_imgs = glob.glob(PANEO_SITE_DATA_DIR + '_tmp/cache/img/%s_*' % k ) 
                        for cache_img in cache_imgs:
                            os.remove(cache_img)

                #data
                if i[k+'_alt'] != "":
                    alt =  i[k+'_alt']
                else:
                    alt = img.get('alt')

                if i[k + '_src'] != "":
                    src =  i[k+'_src']
                else:
                    src = img.get('src')

                if i[k + '_caption'] != "":
                    caption = i[k+'_caption']
                else:
                    caption = ""

                src_on = i.has_key(k+'_src_on')
                if src_on is False:
                    img_src = "/" + PANEO_SITE_DIR + "/img/" + k
                else:
                    img_src = src

                f = PaneoField()
                f.idx = k 
                f.tag = img.name 
                f.type = paneo_type 
                f.name = paneo_name
                f.title = title.strip()
                f.string = None 
                f.ext = {
                        'href'      :   None,
                        'alt'       :   alt,
                        'img_src'   :   img_src,
                        'src'       :   src,
                        'src_on'    :   src_on,
                        'caption'   :   caption,
                }
                fields[k] = f


        for a in bs.find_all('a'):
            paneo_type = a.get('data-paneo-type')
            paneo_name = a.get('data-paneo-name')
            title = a.get('title')
            img = a.find('img')
            if paneo_type is not None and paneo_name is not None and img is not None:
                k = "img_%s_%s_%s" % (prefix,id,paneo_name) 
                #DELETE
                if i.has_key(k+'_file_del'):
                    if os.path.exists(PANEO_SITE_DATA_DIR + "img/" + k):
                        os.remove(PANEO_SITE_DATA_DIR + "img/" + k)

                if i.has_key(k+'_file'):
                    if i[k+'_file'] != "":
                        fout = open(PANEO_SITE_DATA_DIR + "img/" + k,'wb')
                        fout.write(i[k+'_file'])
                        fout.close()
                        #CACHE DELETE
                        cache_imgs = glob.glob(PANEO_SITE_DATA_DIR + '_tmp/cache/img/%s_*' % k ) 
                        for cache_img in cache_imgs:
                            os.remove(cache_img)

                #data
                if i[k+'_alt'] != "":
                    alt =  i[k+'_alt']
                else:
                    alt = img.get('alt')

                if i[k + '_src'] != "":
                    src =  i[k+'_src']
                else:
                    src = img.get('src')

                if i[k + '_href'] != "":
                    href =  i[k+'_href']
                else:
                    href = a.get('href')

                f = PaneoField()
                f.idx = k 
                f.tag = img.name 
                f.type = paneo_type 
                f.name = paneo_name
                f.title = title.strip()
                f.string = None 
                f.ext = {
                        'href'      :   href,
                        'alt'       :   alt,
                        'img_src'   :   img_src,
                        'src'       :   src,
                        'src_on'    :   i.has_key(k+'_src_on'),
                }
                fields[k] = f

        return fields



    def GetPaneoBackGroundFields(self,prefix,id,fields,post=None):

        bs = self.__PageBeautifulSoupMakoCompile(id,post)
        paneo_fields = {}

        n = 1 
        for tag in bs.find_all(attrs={'data-paneo-type':'background'}):
            if tag.name == 'body':
                bk_id = 'body'
            else:
                bk_id = tag.get('id')

            paneo_type = 'background'
            paneo_name = "%s_%s" % ( id , bk_id )
            title = tag.get('title')

            src = tag.get('data-paneo-background-url')
            if src is None :
                src = tag.get('data-paneo-url','')

            if paneo_name :
                k = ('bk_%s_%s_%s_img'%(prefix,id,bk_id))
                fld = fields.get(k)
                if fld :
                    ext = fld.get('ext',{})
                    style = ext.get('style',{})
                    img_src = ext.get('img_src') 
                    src = ext.get('src') 
                    src_on = ext.get('src_on') 
                    size = style.get('size') 
                    repeat = style.get('repeat') 
                    position = style.get('position') 
                    etc = style.get('etc') 
                else:
                    img_src = src 
                    src = src 
                    src_on = False
                    size = "contain"
                    repeat = "no-repeat"
                    position = "0 0"
                    etc = ""

                #画像があるかどうかチェック
                if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                    if src_on is False:
                        img_src = "/" + PANEO_SITE_DIR + "/img/" + k

                if title is None:
                    title = u"背景画像 %s [%s]" % ( tag.name ,  n )

                f = PaneoField()
                f.idx = n
                f.tag = tag.name 
                f.type = paneo_type 
                f.name = paneo_name 
                f.title = title.strip()
                f.string = None 
                f.ext = {
                    'bk_id'     : bk_id,
                    'href'      : None,
                    'img_src'   : img_src,
                    'src'       : src,
                    'src_on'    : src_on,
                    'alt'       : None,
                    'style'     : { 
                                'size':     size,
                                'repeat':   repeat,
                                'position': position,
                                'etc':      etc,
                                }
                }
                paneo_fields[k] = f 
                n = n + 1

        return paneo_fields


    def PostPaneoBackGroundFields(self,prefix,i,id,fields,post=None):

        bs = self.__PageBeautifulSoupMakoCompile(id,post)

        for tag in bs.find_all(attrs={'data-paneo-type':'background'}):

            if tag.name == 'body':
                bk_id = 'body'
            else:
                bk_id = tag.get('id')

            paneo_type = 'background'
            paneo_name = "%s_%s" % ( id , bk_id )
            title = tag.get('title','')

            img_src = tag.get('data-paneo-background-url')
            if img_src is None :
                img_src = tag.get('data-paneo-url','')

            if paneo_name :
                k = ('bk_%s_%s_%s_img'%(prefix,id,bk_id))
                #DELETE
                if i.has_key(k+'_file_del'):
                    if os.path.exists(PANEO_SITE_DATA_DIR + "img/" + k):
                        os.remove(PANEO_SITE_DATA_DIR + "img/" + k)
                #UPLAOD
                if i.has_key(k+'_file'):
                    if i[k+'_file'] != "":
                        fout = open(PANEO_SITE_DATA_DIR + "img/" + k,'wb') 
                        fout.write(i[k+'_file']) 
                        fout.close() 
                        #CACHE DELETE
                        cache_imgs = glob.glob(PANEO_SITE_DATA_DIR + '_tmp/cache/img/%s_*' % k ) 
                        for cache_img in cache_imgs:
                            os.remove(cache_img)

                #background css data
                if i[k + '_src'] != "":
                    src =  i.get(k+'_src','')
                else:
                    src = img_src 

                if i[k + '_size'] != "":
                    size =  i[k+'_size']
                else:
                    size = tag.get('size')

                if i[k + '_repeat'] != "":
                    repeat =  i[k+'_repeat']
                else:
                    repeat = tag.get('repeat')

                if i[k + '_position'] != "":
                    position =  i[k+'_position']
                else:
                    position = tag.get('position')
                   
                if i[k + '_etc'] != "" and i[k+'_etc'] is not None :
                    etc =  i[k+'_etc']
                else:
                    etc = tag.get('etc')

                src_on = i.has_key(k+'_src_on')

                f = PaneoField()
                f.idx = k 
                f.tag = tag.name 
                f.type = paneo_type 
                f.name = paneo_name 
                f.title = title.strip()
                f.string = None 
                f.ext = {
                    'bk_id'     : bk_id,
                    'href'      : None,
                    'img_src'   : img_src,
                    'src'       : src,
                    'src_on'    : src_on,
                    'alt'       : None,
                    'style'     : { 
                                'size': size,
                                'repeat': repeat,
                                'position': position,
                                'etc': etc,
                                }
                }

                fields[k] = f

        return fields



    def GetPaneoAmazonFields(self,prefix,id,fields,post=None):

        bs = self.__PageBeautifulSoupMakoCompile(id,post)

        paneo_fields = {}

        n = 1 
        for ama in bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'item'}):
            paneo_type = ama.get('data-paneo-type')
            paneo_name = ama.get('data-paneo-name')
            view_type = ama.get('data-paneo-amazon')
            title = ama.get('title')
            if paneo_name is not None:
                k = ('ama_%s_%s_%s'%(prefix,id,paneo_name))
                fld = fields.get(k)
                if fld :
                    ext = fld.get('ext',{})
                    ama_asin = ext.get('asin',{}) 
                else:
                    ama_asin = {} 

                if title is None:
                    title = u"アマゾン %s [%s]" % ( ama.name ,  n )
               
                f = PaneoField()
                f.idx = n
                f.tag = ama.name
                f.type = paneo_type 
                f.name = paneo_name
                f.title = title
                f.string = None 
                f.ext = {
                            'view': view_type,
                            'asin': ama_asin,
                }
                paneo_fields[k] = f 
                n = n + 1

        ##SEARCH
        n = 101
        for ama in bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'search'}):
            paneo_type = ama.get('data-paneo-type')
            paneo_name = ama.get('data-paneo-name')
            view_type = ama.get('data-paneo-amazon')
            title = ama.get('title')
            if paneo_name is not None:
                k = ('ama_%s_%s_%s'%(prefix,id,paneo_name))
                fld = fields.get(k)

                if fld :
                    ext = fld.get('ext',{})
                    ama_searchindex =   ext.get('searchindex') 
                    ama_kw =            ext.get('kw') 
                    ama_itempage =      ext.get('itempage') 
                    ama_sort =          ext.get('sort') 
                else:
                    ama_searchindex = "All" 
                    ama_kw = "" 
                    ama_itempage = "1" 
                    ama_sort = "" 

                if title is None:
                    title = u"アマゾン SEARCH %s [%s]" % ( ama.name ,  n )

                f = PaneoField()
                f.idx = n
                f.tag = ama.name
                f.type = paneo_type 
                f.name = paneo_name
                f.title = title
                f.string = None 
                f.ext = {
                            'view':         view_type,
                            'asin':         ama_asin,
                            'searchindex':  ama_searchindex,
                            'kw':           ama_kw, 
                            'itempage':     ama_itempage,
                            'sort':         ama_sort,
                }
                paneo_fields[k] = f 
                n = n + 1

        return paneo_fields


    def PostPaneoAmazonFields(self,prefix,i,id,fields,post=None):

        bs = self.__PageBeautifulSoupMakoCompile(id,post)

        #ITEM
        for ama in bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'item'}):
            paneo_type = ama.get('data-paneo-type')
            paneo_name = ama.get('data-paneo-name')
            view_type = ama.get('data-paneo-amazon')
            title = ama.get('title')
            if paneo_name is not None:
                k = ('ama_%s_%s_%s'%(prefix,id,paneo_name))
                fld = fields.get(k)
                ama_asin = {}
                for ii in range(1,11):
                    ama_asin["I:%s"%ii] = i.get("%s_asin_%s"%(k,ii))

                f = PaneoField()
                f.idx = k 
                f.tag = ama.name
                f.type = paneo_type 
                f.name = paneo_name
                f.title = title
                f.string = None 
                f.ext = {
                            'view': view_type,
                            'asin': ama_asin,
                }
                fields[k] = f 

        ##SEARCH
        for ama in bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'search'}):
            paneo_type = ama.get('data-paneo-type')
            paneo_name = ama.get('data-paneo-name')
            view_type = ama.get('data-paneo-amazon')
            title = ama.get('title','')

            if paneo_name is not None:
                k = ('ama_%s_%s_%s'%(prefix,id,paneo_name))
                fld = fields.get(k)

                f = PaneoField()
                f.idx = k 
                f.tag = ama.name
                f.type = paneo_type 
                f.name = paneo_name
                f.title = title
                f.string = None 
                f.ext = {
                            'view':         view_type,
                            'asin':         ama_asin,
                            'searchindex':  i.get('SEARCHINDEX'),
                            'kw':           i.get('KW'),
                            'itempage':     i.get('ITEMPAGE'),
                            'sort':         i.get('SORT'),
                }
                fields[k] = f 

        return fields


    def __len__(self):
        return len(self.__dict__)

    def __repr__(self):
        return str(self.__dict__)

    def __str__(self):
        return str(self.__dict__)

    def __iter__(self):
        return self.__dict__.iteritems()

    def __getitem__(self, key):
        return self.__dict__[key]

    def __setitem__(self, key, value):
        self.__dict__[key] = value

    def get( self, key , default= None ):
        return self.__dict__.get(key,default)

    def has_key( self, key ):
        return self.__dict__.has_key( key )







class Page(PaneoPage):
    pass





class PaneoField(object):

    def __init__(   self,
                    idx         = None,
                    name        = None,
                    type        = None,
                    tag         = None, 
                    title       = None,
                    string      = None,
                    ext         = None,
                ): 
        
        self.idx = idx
        self.tag = tag
        self.type = type
        self.name = name
        self.title = title
        self.string = string
        self.ext = ext
   

    def __len__(self):
        return len(self.__dict__)

    def __repr__(self):
        return str(self.__dict__)

    def __str__(self):
        return str(self.__dict__)

    def __iter__(self):
        return self.__dict__.iteritems()

    def __getitem__(self, key):
        return self.__dict__[key]

    def __setitem__(self, key, value):
        self.__dict__[key] = value

    def get( self, key , default= None ):
        return self.__dict__.get(key,default)

    def has_key( self, key ):
        return self.__dict__.has_key( key )

from PIL import Image
from cStringIO import StringIO

class TemplateThumb:
    def GET( self, type, prefix, name ):
        img_file = PANEO_SITE_DATA_DIR + '_paneo_data/templates/'+type+'_templateset/' + prefix + '/' + name + '.png' 
        if os.path.exists( img_file ):
            img = open(img_file,"rb").read()
            web.header("Content-Length", len(img))
            web.header("Content-Type", "image/%s; charset=UTF-8" % img.format)
            return img
        else:
            img = Image.new("RGB",(320,640),"#e0e0e0")
            fo = StringIO()
            img.save(fo,"png")
            web.header("Content-Type", "image/png; charset=UTF-8")
            return fo.getvalue()


